unit UnitPlantilla;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem;

type
  TFormJocRectangles = class(TForm)
    PanelIntensuitatJocDelsRectangles: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    ValorMinim:integer;
  end;

var
  FormJocRectangles: TFormJocRectangles;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitEntradaSo;
{$R *.DFM}

procedure TFormJocRectangles.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
end;

procedure TFormJocRectangles.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormJocRectangles.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
  R:TRect;
  h,a,x1,y1,x2,y2:integer;
  c1,c2,c3:integer;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if Max>ValorMinim then begin
    R:=GetClientRect;
    a:=(R.Right-R.Left);
    h:=(R.Bottom-R.Top);
    x1:=Random(round(a / 1.5));
    y1:=Random(round(h / 1.5));
    x2:=x1+Random(a div 2);
    y2:=y1+Random(h div 2);
    c1:=Random(7);
    if c1=0 then begin
      c1:=128;c2:=128;c3:=128;
    end else if c1=1 then begin
      c1:=255;c2:=0;c3:=0;
    end else if c1=2 then begin
      c1:=0;c2:=255;c3:=0;
    end else if c1=3 then begin
      c1:=0;c2:=0;c3:=255;
    end else if c1=4 then begin
      c1:=255;c2:=255;c3:=0;
    end else if c1=5 then begin
      c1:=255;c2:=0;c3:=255;
    end else if c1=6 then begin
      c1:=0;c2:=255;c3:=255;
    end else if c1=7 then begin
      c1:=0;c2:=0;c3:=0;
    end;
    Canvas.Brush.Color:=RGB(c1,c2,c3);
    Canvas.Rectangle(x1,y1,x2,y2);
  end else Repaint;
  EntradaSo;
end;

procedure TFormJocRectangles.FormCreate(Sender: TObject);
begin
  ValorMinim:=20;
  Randomize;
end;

end.
